#include <bits/stdc++.h>
using namespace std;

struct Jarbol 
{
    int x, h, idx;
};

vector<int> nextGreaterRight(const vector<Jarbol>& a) {
    int n = a.size();
    vector<int> res(n, -1);
    stack<int> st;

    for (int i = n - 1; i >= 0; --i) {
        while (!st.empty() && a[st.top()].h < a[i].h)
            st.pop();
        if (!st.empty())
            res[i] = st.top();
        st.push(i);
    }
    return res;
}

vector<int> nextGreaterLeft(const vector<Jarbol>& a) {
    int n = a.size();
    vector<int> res(n, -1);
    stack<int> st;

    for (int i = 0; i < n; ++i) {
        while (!st.empty() && a[st.top()].h < a[i].h)
            st.pop();
        if (!st.empty())
            res[i] = st.top();
        st.push(i);
    }
    return res;
}

int main() 
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Jarbol> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i].x;
    for (int i = 0; i < n; ++i) {
        cin >> a[i].h;
        a[i].idx = i;
    }

    sort(a.begin(), a.end(), [](const Jarbol& p, const Jarbol& q) {
        return p.x < q.x;
    });

    vector<int> R = nextGreaterRight(a);
    vector<int> L = nextGreaterLeft(a);

    vector<long long> ans(n, -1);

    for (int i = 0; i < n; ++i) {
        long long best = LLONG_MAX;

        if (R[i] != -1) {
            int j = R[i];
            best = min(best, (long long)(a[j].x - a[i].x + a[i].h - a[j].h));
        }

        if (L[i] != -1) {
            int j = L[i];
            best = min(best, (long long)(a[i].x - a[j].x + a[i].h - a[j].h));
        }

        if (best != LLONG_MAX)
            ans[a[i].idx] = best;
    }

    for (long long v : ans)
        cout << v << '\n';
        
    return 0;
}